// AgentDialog.java
// Olof 5 feb
// Olof 12 feb
// Jonas 13 feb

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;
import Agent;
import MobileHost;

public class AgentDialog extends Dialog implements ActionListener {
  Button sendButton, cancelButton, downButton, upButton;
  int i, temp, diaLoc;
  Label label1, label2, label3;
  Panel p1, p2, p4;
  Graphics g;
  TextField field;
  Integer th;
  Agent connected;
  GridBagFrame father;
  String inclText1, inclText2, inclText3, inclText4;
  IncludThread includT;
  
  // Constructor
  AgentDialog(int i, GridBagFrame father, Graphics g) {
    super(father, "AgentDialog", false);
    this.i = i;
    this.diaLoc = diaLoc;
    this.g = g;
    this.father = father;
    
    upButton = new Button("+");
    upButton.addActionListener(this);
    downButton = new Button("-");
    downButton.addActionListener(this);
    cancelButton = new Button("Close");
    cancelButton.addActionListener(this);
    field = new TextField(4);
    field.addActionListener(this);
    
    sendButton = new Button("Send data to MH");
    sendButton.addActionListener(this);
    Panel p3 = new Panel();
    p3.add(cancelButton);
    p3.add(sendButton);
    add("South", p3);
    
    label1 = new Label();
    label2 = new Label();
    label3 = new Label();
    p2 = new Panel();
    p4 = new Panel();
    p1 = new Panel();
    reDraw1();
    reDraw2();
    g = super.getGraphics();
  }
  
  public void reDraw1() { // Changed to public from private by Jonas 9/2
    label1.setText(Globals.FA[i].name);
    
    p1.add("North", label1);
    add("North", p1);
    this.show();
  }
  
  public void reDraw2() { // Changed to public from private by Jonas 9/2
    label2.setText("Range: ");      
    p2.add("North", label2);
    field.setText(String.valueOf(Globals.FA[i].range));
    p2.add("North", field);
    p2.add("North", upButton);
    p2.add("North", downButton);
    if (Globals.FA[i].believeMH != null)
      label3.setText("Believes that MH is at " + Globals.FA[i].believeMH.name);
    else
      label3.setText("Does not know where MH is");
    p2.add("South", label3);
    add("Center", p2);
    this.show();
  }
    
  public void checkConnection() {
    connected = father.IPCanvas.findConnection();
    if (connected != Globals.MH.connected) {
      if (connected == null) {            // MH deregisters with Agent
	father.IPCanvas.excludationMH();   // Writing dereg.text
	reDraw2();
      }
      else {
	if (Globals.MH.connected != null) {  // Not only do includation?
	  Agent closest = father.IPCanvas.findClosest();
	  if (connected == closest) {
	    Globals.doInc = true;
	    Globals.newAgent = connected;
	    father.IPCanvas.deregistrationMH();
	  }
	  else {
	    Globals.doReg = true;
	    Globals.newAgent = connected;
	    father.IPCanvas.excludationMH();
	    reDraw2();
	  }
	}
	else {
	  Globals.MH.connected = connected;
	  Globals.MH.connected.believeMH = Globals.MH.connected;
	  // reDraw2();
	  father.IPCanvas.includationMH();   // Writing reg.text
	}
      }
    } 
  }
  
  public void actionPerformed(ActionEvent event) {
    Object source = event.getSource();
    
    
    if ((source == upButton) && Globals.actionAllowed) {
      g.setColor(Color.lightGray); 
      temp = (int) Globals.FA[i].range/2;
      g.drawOval(Globals.FA[i].x+14-temp, Globals.FA[i].y+13-temp,
		 Globals.FA[i].range, Globals.FA[i].range);
      Globals.FA[i].range = Globals.FA[i].range+1;
      
      checkConnection();
      
      father.IPCanvas.paint(g);
      reDraw2();
    }
    
    if ((source == downButton) && Globals.actionAllowed &&
	(Globals.FA[i].range >= 36)) {
      g.setColor(Color.lightGray); 
      temp = (int) Globals.FA[i].range/2;
      g.drawOval(Globals.FA[i].x+14-temp, Globals.FA[i].y+13-temp, Globals.FA[i].range, Globals.FA[i].range); 
      Globals.FA[i].range = Globals.FA[i].range-1;
      
      checkConnection();
      
      father.IPCanvas.paint(g);
      reDraw2();
    }
    
    if ((source == field) && Globals.actionAllowed){
      try {
	int newrange = Integer.parseInt(field.getText());
	g.setColor(Color.lightGray); 
	temp = (int) Globals.FA[i].range/2;
	int max = getMaxRange();
	g.drawOval(Globals.FA[i].x+14-temp, Globals.FA[i].y+13-temp,
		   Globals.FA[i].range, Globals.FA[i].range);
	
	if (newrange >= 36) 
	  /*if (max < newrange)
	    Globals.FA[i].range = max;
	else*/
	    Globals.FA[i].range = Integer.parseInt(field.getText());
	else
	  Globals.FA[i].range = 35;
	
	checkConnection();
	
	father.IPCanvas.paint(g);
	reDraw2();
      }
      catch (NumberFormatException e) {reDraw2();}
    }
    
    if  (source == cancelButton) {
      setVisible(false);
      Globals.dialogExist[i] = false;
    }

    // User wants to send data to MH
    if ((source == sendButton) && Globals.actionAllowed){
	father.textArea1.appendHiLit("\nDATA TO MH\n");
	if (Globals.FA[i] != Globals.MH.connected) 
	  // Shall data be tunneled?
	  if (Globals.FA[i].believeMH == Globals.FA[0])
	    father.IPCanvas.sendLetterViaHA(Globals.FA[i]);
	  else 
	    if ((Globals.MH.connected == null) &&
		(Globals.FA[i] == Globals.FA[0]))
	      father.textArea1.appendHiLit("- Cannot send data while MH is unconnected\n");
	    else
	      father.IPCanvas.sendLetterTunnel(Globals.FA[i]);
	else 
	  father.IPCanvas.sendLetter(Globals.FA[i], Globals.FA[i]);
    } 
  }

  public int getMaxRange() {
    int temp;
    int max = 10000;
    for (int nr=0; nr <=3; nr++) {
      temp = (int) Math.sqrt((Globals.FA[i].x-Globals.FA[nr].x)
                           * (Globals.FA[i].x-Globals.FA[nr].x)
                           + (Globals.FA[i].y-Globals.FA[nr].y)
                           * (Globals.FA[i].y-Globals.FA[nr].y))
                           -  Globals.FA[nr].range/2;
      if ((max > temp) && (temp > 0))
	max = temp;
    }
    return 2*max;
  }
} 
